% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program WedgeRing.m
[x,  y] = meshgrid(-1024:1023,  1024:-1:-1023);
theta = atan2(y,  x);  % translates x, y to polar angle
r = sqrt(x.^2 + y.^2); % and radius
sWidth = pi/8;         % width of each wedge in polar angle
mask1 = 2*round((sin(theta*2*(2*pi/sWidth)) + 1)/2) - 1; 
                       % make wedge pattern
r0=[ 64 96 144 208 288 400 528 672 832 1024]; 
                       % radii of different rings
mask2 = (r < r0(1));
for i = 2:10
  mask2 = mask2 + (2*mod(i,2) - 1)*(r >= r0(i-1) & r < r0(i));
end
mask3 = mask1.*mask2;
Wmask = (theta  > -pi/6 & theta < pi/6);
Rmask = (r > 64 & r <= 144) + (r > 672 & r < 1024);
Wedge = Wmask.*mask3*127 + 128;
Ring = Rmask.*mask3*127 + 128;
showImage(Wedge,   'grayscale');
showImage(Ring,   'grayscale');

